:- module(los_betos,_,[dcg,functions]).

:- use_module(library(lists)).
:- use_module(library(strings)).
:- use_module(library(file_utils)).
:- use_module(library(read)).
:- use_module(library(write)).


% avoid nasty issues
:- set_prolog_flag(write_strings,on).
:- set_prolog_flag(multi_arity_warnings,off).

isChar(X) :- X >= 0'a, X =< 0'z, !.
isChar(X) :- X >= 0'A, X =< 0'Z, !.
isChar(0'_).

isNumber(X) :- X >= 0'0, X =< 0'9.

epsilon --> "".

numeral(singular,masculine) -->
	"un" 
      | epsilon.
numeral(singular,femenine) -->
	"una" 
      | epsilon.
numeral(plural, masculine) -->
	"dos" 
      |"tres" 
      |"cuatro"
      |"cinco"
      |"seis" 
      |"siete" 
      |"ocho" 
      |"nueve".

numeral(plural,femenine) :- numeral(plural, masculine).

isValidId(_X).

token -->
	[_],
	(token
	| whitespace, token
	| whitespace, epsilon
	).

introductory_expression -->
	token.

item(singular,masculine) -->
	"burrito" 
      | "taco"
      | "menudo".
item(singular,femenine) -->
       "enchilada"
      | "flauta".
item(plural,Genre) --> item(singular,Genre), "s".

order_modifier -->
      ("(",
      ( "sin queso"      % no cheese
      | "chile verde"    % green chile
      | "chile rojo"     % red chile
      | "no muy picante" % not very spicy
      ),
      ")")
      | epsilon.

order -->
	numeral(Number,Genre),
	whitespace,
	item(Number,Genre),
	whitespace,
	order_modifier,	
	(epsilon
	| whitespace,("con"|"y") ,whitespace,order).

soda -->
	"Coca-Cola" 
      | "Dr Pepper".

diet_soda -->
	"Diet", whitespace, soda.

drink_item(singular) -->
	soda
      | diet_soda
      | "root beer"
      | "cafe".
drink_item(plural) --> drink_item(singular), "s".

drink_modifier -->
       "(",
       ( "sin hielo"    % no ice
       | "poco hielo"), % easy ice
       ")"
       | epsilon.

drink -->
	numeral(Number,_),
	whitespace,
	drink_item(Number),
	(epsilon
	|whitespace,drink_modifier),
	(epsilon
	| whitespace,("con"|"y") ,whitespace,drink).
	
 
food_order -->
	whitespace0,
	(epsilon 
        | introductory_expression),
	whitespace0,
	order,
	whitespace,
	drink,
	whitespace0, 
	(epsilon| "por favor").


