:-module(stack,
	[
	 %% predicates
	 s_empty/1, s_stack/3, s_stack_union/3, s_stack_all/3,
	 s_stack_all_union/3, s_member/2, s_delete/3,
	 %% regtypes
	 stack/1
	],
	[assertions,isomodes,regtypes]).

:-use_module(library(lists)).

:- comment(title, "Stack").
:- comment(author,"Jorge Navas").
:- comment(module,"This module provides a set of predicates for
	           @index{stack}s processing. It uses the library
	           @lib{lists} defined in the @concept{Ciao-Prolog
	           System}.").

%% Predicates

:- pred s_empty(?S):: stack
#" @var{S} is empty. 

   @item @em{Code:}
   @includedef{s_empty/1}
".

s_empty([]).

:- pred s_stack(-E,-S1,+S2):: term * stack * stack
#"Pushs @var{E} into @var{S1} producing @var{S2}.
 
   @item @em{Code:}
   @includedef{s_stack/3}".

:- pred s_stack(+E,+S1,-S2):: term * stack * stack
#"Pops the top element @var{E} of @var{S2}, producing @var{S1} without
 @var{E}.

   @item @em{Code:}
   @includedef{s_stack/3}".

s_stack(E,S,[E|S]). 

:- pred s_stack_union(-E,-S1,+S2):: term * stack * stack
#"Pushs @var{E} into @var{S1} producing @var{S2}. When @var{E} belongs to
 @var{S1}, @var{E} is not added to @var{S2}.

   @item @em{Code:}
   @includedef{s_stack_union/3}".

s_stack_union(E,S,S):- s_member(E,S),!.
s_stack_union(E,S,[E|S]).

:- pred s_stack_all(-Es,-S1,+S2):: list(term) * stack * stack
#"Pushs a list of elements @var{Es} into @var{S1} producing @var{S2}.

   @item @em{Code:}
   @includedef{s_stack_all/3}".

s_stack_all([],S,S).
s_stack_all([E|Es],S1,S) :- s_stack(E,S1,S2), s_stack_all(Es,S2,S).

:- pred s_stack_all_union(-Es,-S1,+S2):: list(term) * stack * stack
#"Pushs a list of elements @var{Es} into @var{S1} producing @var{S2}. When
 a element of @var{Es} belongs to @var{S1}, this element is not added to @var{S2}.

   @item @em{Code:}
   @includedef{s_stack_all_union/3}".

s_stack_all_union([],S,S).
s_stack_all_union([E|Es],S1,S) :- s_stack_union(E,S1,S2), s_stack_all_union(Es,S2,S).

:- pred s_member(?E,-S):: term * stack 
#"Checks the element @var{E} belongs to @var{S}.

   @item @em{Code:}
   @includedef{s_member/2}".

s_member(E, S):- member(E,S).

:- pred s_delete(-E,-S1,+S2):: term * stack * stack
# "@var{S2} is @var{S1} without the element @var{E}.

   @item @em{Code:}
   @includedef{s_delete/3}".

s_delete(E, S1,S2):-  delete(S1,E,S2).

%% Regtypes

:- regtype stack(S) #"@var{S} is a @concept{stack}.".

stack(S):- list(S).

