%%% CS527, Natural Language Processing Homework
%%%
%%% Nikita Sakhanenko
%%% sanik@cs.unm.edu
%%%
%%% PROLOG Semantic Net Parser for overly simplified Russian Grammar:
%%%  - present tense only;
%%%  - support for cases, gender, person, number;
%%%  - no support for complex sentences;
%%%  - no resolution for semantic ambiguity.
%%%
%%% This is an extension of the English parser from (Luger, 2005).
%%%

% grammar rules with the corresponding graphs, 
% constraints of which are merged together by 
% calling join

utterance( X, SentenceGraph ) :-
    sentence( X, [], Sentence_graph ),
    write('ANSW: '),write(Sentence_graph).

% here I assume that all russian sentences contain words in nominative case
% which is not the case in general...

sentence( Start, End, Sentence_graph ) :-
    nounphrase( Start, Rest, Number, Person, Case, Subject_graph ),
    verbphrase( Rest, End, Number, Person, Predicate_graph, Subject_graph ),
    join( [agent(Subject_graph)], Predicate_graph, Sentence_graph ).

sentence( Start, End, Sentence_graph ) :-
    verbphrase( Start, End, _, Person, Sentence_graph, _ ).

nounphrase( [Noun|End], End, Number, Person, Case, Noun_phrase_graph ) :- 
    noun( Noun, Number, Gender, Case, Noun_phrase_graph ),
    Person = third.

nounphrase( [Prep,Noun|End], End, Number, Person, Case, Noun_phrase_graph ) :- 
    preposition( Prep, Case ),
    noun( Noun, Number, Gender, Case, Noun_phrase_graph ),
    Person = third.

nounphrase( [Pronoun|End], End, Number, Person, Case, Noun_phrase_graph ) :- 
    pronoun( Pronoun, Number, Gender, Person, Case, Noun_phrase_graph ). 

nounphrase( [Prep,Pronoun|End], End, Number, Person, Case, Noun_phrase_graph ) :- 
    preposition( Prep, Case ),
    pronoun( Pronoun, Number, Gender, Person, Case, Noun_phrase_graph ). 

% here I assume that a noun can have only one adjective connected
% to it; again, it is not the case in general...

nounphrase( [Adjective, Noun|End], End, Number, Person, Case, Noun_phrase_graph ) :-
    adjective( Adjective, Number, Gender, Case ),
    noun( Noun, Number, Gender, Case, Noun_phrase_graph ),
    Person = third.

nounphrase( [Prep, Adjective, Noun|End], End, Number, Person, Case, Noun_phrase_graph ) :-
    preposition( Prep, Case ),
    adjective( Adjective, Number, Gender, Case ),
    noun( Noun, Number, Gender, Case, Noun_phrase_graph ),
    Person = third.

nounphrase( [Noun, Adjective|End], End, Number, Person, Case, Noun_phrase_graph ) :-
    noun( Noun, Number, Gender, Case, Noun_phrase_graph ),
    adjective( Adjective, Number, Gender, Case ),
    Person = third.

nounphrase( [Prep, Noun, Adjective|End], End, Number, Person, Case, Noun_phrase_graph ) :-
    preposition( Prep, Case ),
    noun( Noun, Number, Gender, Case, Noun_phrase_graph ),
    adjective( Adjective, Number, Gender, Case ),
    Person = third.

verbphrase( [Verb|End], End, Number, Person, Verb_phrase_graph, _ ) :-
    verb( Verb, Number, Person, Verb_phrase_graph ).

verbphrase( [Verb|Rest], End, Number, Person, Verb_phrase_graph, _ ) :-
    verb( Verb, Number, Person, Verb_graph ),
    nounphrase( Rest, End, _,  _, _, Noun_phrase_graph ),
    join( [object(Noun_phrase_graph)], Verb_graph, Verb_phrase_graph ).


% graph join operation

join( X, X, X ).

join( A, B, C ) :-
    isframe( A ), 
    isframe( B ), 
    !,
    join_frames( A, B, C, not_joined ).

join( A, B, C ) :-
    isframe( A ), 
    is_slot( B ), 
    !,
    join_slot_to_frame( B, A, C ).

join( A, B, C ) :-
    isframe( B ), 
    is_slot( A ), 
    !,
    join_slot_to_frame( A, B, C ).

join( A, B, C ) :-
    is_slot( A ), 
    is_slot( B ), 
    !,
    join_slots( A, B, C ).


join_frames( [A | B], C, D, OK ) :-
    join_slot_to_frame( A, C, E ), 
    !,
    join_frames( B, E, D, ok ).

join_frames( [A | B], C, [A | D], OK) :-
    join_frames( B, C, D, OK ), 
    !.

join_frames( [], A, A, ok ).


join_slot_to_frame( A, [B | C], [D | C] ) :- join_slots( A, B, D ).

join_slot_to_frame( A, [B | C], [B | D] ) :- join_slot_to_frame( A, C, D ).


join_slots( A, B, D ) :-
    functor( A, FA, _ ), 
    functor( B, FB, _ ),
    match_with_inheritance( FA, FB, FN ),
    arg( 1, A, Value_a ), 
    arg( 1, B, Value_b ),
    join( Value_a, Value_b, New_value ),
    D=..[FN | [New_value]].


isframe( [_|_] ).

isframe( [] ).

is_slot( A ) :- functor( A, _, 1 ).


% Here I create the dictionary entries. Note that there are no latin letters
% in Russian language, only cyrillic letters; hence I am using transliteration
% of cyrillic alphabet (for more info see 
% http://infoshare1.princeton.edu/katmandu/sgman/trrus.html).

match_with_inheritance( X, X, X).
match_with_inheritance( human, animate, human).
match_with_inheritance( animate, human, human).

match_with_inheritance( insect, animate, insect).
match_with_inheritance( animate, insect, insect).
match_with_inheritance( insect, inhuman, insect ).
match_with_inheritance( inhuman, insect, insect ).

match_with_inheritance( game, inanimate, game ).
match_with_inheritance( inanimate, game, game ).

match_with_inheritance( food, inanimate, food ).
match_with_inheritance( inanimate, food, food ).

match_with_inheritance( unknown, animate, animate ).
match_with_inheritance( animate, unknown, animate ).
match_with_inheritance( unknown, inanimate, inanimate ).
match_with_inheritance( inanimate, unknown, inanimate ).

% the section for nouns; syntactic difference depending on
% a gender, a number and a case (there are 6 cases)

% a human being
noun( chelovek, singular, masculine, nominative, [human(chelovek)] ).
noun( liudi, plural, masculine, nominative, [human(liudi)] ).
noun( cheloveka, singular, masculine, genitive, [human(chelovek)] ).
noun( liudei, plural, masculine, genitive, [human(liudi)] ).
noun( cheloveku, singular, masculine, dative, [human(chelovek)] ).
noun( liudiam, plural, masculine, dative, [human(liudi)] ).
noun( cheloveka, singular, masculine, accusative, [human(chelovek)] ).
noun( liudei, plural, masculine, accusative, [human(liudi)] ).
noun( chelovekom, singular, masculine, instrumental, [human(chelovek)] ).
noun( liudiami, plural, masculine, instrumental, [human(liudi)] ).
noun( cheloveke, singular, masculine, prepositional, [human(chelovek)] ).
noun( liudiakh, plural, masculine, prepositional, [human(liudi)] ).

% a young woman
noun( devushka, singular, feminine, nominative, [human(devushka)] ).
noun( devushki, plural, feminine, nominative, [human(devushki)] ).
noun( devushki, singular, feminine, genitive, [human(devushka)] ).
noun( devushek, plural, feminine, genitive, [human(devushki)] ).
noun( devushke, singular, feminine, dative, [human(devushka)] ).
noun( devushkam, plural, feminine, dative, [human(devushki)] ).
noun( devushku, singular, feminine, accusative, [human(devushka)] ).
noun( devushek, plural, feminine, accusative, [human(devushki)] ).
noun( devushkoi, singular, feminine, instrumental, [human(devushka)] ).
noun( devushkami, plural, feminine, instrumental, [human(devushki)] ).
noun( devushke, singular, feminine, prepositional, [human(devushka)] ).
noun( devushkakh, plural, feminine, prepositional, [human(devushki)] ).

% a grasshopper

noun( kuznechik, singular, masculine, nominative, [insect(kuznechik)] ).
noun( kuznechiki, plural, masculine, nominative, [insect(kuznechiki)] ).
noun( kuznechika, singular, masculine, genitive, [insect(kuznechik)] ).
noun( kuznechikov, plural, masculine, genitive, [insect(kuznechiki)] ).
noun( kuznechiku, singular, masculine, dative, [insect(kuznechik)] ).
noun( kuznechikam, plural, masculine, dative, [insect(kuznechiki)] ).
noun( kuznechika, singular, masculine, accusative, [insect(kuznechik)] ).
noun( kuznechikov, plural, masculine, accusative, [insect(kuznechiki)] ).
noun( kuznechikom, singular, masculine, instrumental, [insect(kuznechik)] ).
noun( kuznechikami, plural, masculine, instrumental, [insect(kuznechiki)] ).
noun( kuznechike, singular, masculine, prepositional, [insect(kuznechik)] ).
noun( kuznechikakh, plural, masculine, prepositional, [insect(kuznechiki)] ).

% a fly

noun( mukha, singular, feminine, nominative, [insect(mukha)] ).
noun( mukhi, plural, feminine, nominative, [insect(mukhi)] ).
noun( mukhu, singular, feminine, genitive, [insect(mukha)] ).
noun( mukh, plural, feminine, genitive, [insect(mukhi)] ).
noun( mukhe, singular, feminine, dative, [insect(mukha)] ).
noun( mukham, plural, feminine, dative, [insect(mukhi)] ).
noun( mukhu, singular, feminine, accusative, [insect(mukha)] ).
noun( mukh, plural, feminine, accusative, [insect(mukhi)] ).
noun( mukhoi, singular, feminine, instrumental, [insect(mukha)] ).
noun( mukhami, plural, feminine, instrumental, [insect(mukhi)] ).
noun( mukhe, singular, feminine, prepositional, [insect(mukha)] ).
noun( mukhakh, plural, feminine, prepositional, [insect(mukhi)] ).

% a loto

noun( loto, singular, neuter, nominative, [game(loto)]).
noun( loto, plural, neuter, nominative, [game(loto)]).
noun( loto, singular, neuter, genitive, [game(loto)] ).
noun( loto, plural, neuter, genitive, [game(loto)] ).
noun( loto, singular, neuter, dative, [game(loto)] ).
noun( loto, plural, neuter, dative, [game(loto)] ).
noun( loto, singular, neuter, accusative, [game(loto)] ).
noun( loto, plural, neuter, accusative, [game(loto)] ).
noun( loto, singular, neuter, instrumental, [game(loto)] ).
noun( loto, plural, neuter, instrumental, [game(loto)] ).
noun( loto, singular, neuter, prepositional, [game(loto)] ).
noun( loto, plural, neuter, prepositional, [game(loto)] ).

% a game

noun( igra, singular, feminine, nominative, [game(igra)]).
noun( igry, plural, feminine, nominative, [game(igry)]).
noun( igry, singular, feminine, genitive, [game(igra)] ).
noun( igr, plural, feminine, genitive, [game(igry)] ).
noun( igre, singular, feminine, dative, [game(igra)] ).
noun( igram, plural, feminine, dative, [game(igry)] ).
noun( igru, singular, feminine, accusative, [game(igra)] ).
noun( igry, plural, feminine, accusative, [game(igry)] ).
noun( igroi, singular, feminine, instrumental, [game(igra)] ).
noun( igrami, plural, feminine, instrumental, [game(igry)] ).
noun( igre, singular, feminine, prepositional, [game(igra)] ).
noun( igrakh, plural, feminine, prepositional, [game(igry)] ).

% a siberian dumpling
noun( pelmen, singular, masculine, nominative, [food(pelmen)]).
noun( pelmeni, plural, masculine, nominative, [food(pelmeni)]).
noun( pelmenia, singular, masculine, genitive, [food(pelmen)] ).
noun( pelmenei, plural, masculine, genitive, [food(pelmeni)] ).
noun( pelmeniu, singular, masculine, dative, [food(pelmen)] ).
noun( pelmeniam, plural, masculine, dative, [food(pelmeni)] ).
noun( pelmen, singular, masculine, accusative, [food(pelmen)] ).
noun( pelmeni, plural, masculine, accusative, [food(pelmeni)] ).
noun( pelmenem, singular, masculine, instrumental, [food(pelmen)] ).
noun( pelmeniami, plural, masculine, instrumental, [food(pelmeni)] ).
noun( pelmene, singular, masculine, prepositional, [food(pelmen)] ).
noun( pelmeniakh, plural, masculine, prepositional, [food(pelmeni)] ).

% the section for pronouns, which are syntactically different 
% similar to nouns

% I
pronoun( ia, singular, masculine, first, nominative, [human(ia)] ).
pronoun( ia, singular, feminine, first, nominative, [human(ia)] ).
pronoun( menia, singular, masculine, genitive, [human(ia)] ).
pronoun( menia, singular, feminine, genitive, [human(ia)] ).
pronoun( mne, singular, masculine, dative, [human(ia)] ).
pronoun( mne, singular, feminine, dative, [human(ia)] ).
pronoun( menia, singular, masculine, accusative, [human(ia)] ).
pronoun( menia, singular, feminine, accusative, [human(ia)] ).
pronoun( mnoi, singular, masculine, instrumental, [human(ia)] ).
pronoun( mnoi, singular, feminine, instrumental, [human(ia)] ).
pronoun( mne, singular, masculine, prepositional, [human(ia)] ).
pronoun( mne, singular, feminine, prepositional, [human(ia)] ).

% you
pronoun( ty, singular, masculine, second, nominative, [human(ty)] ).
pronoun( ty, singular, feminine, second, nominative, [human(ty)] ).
pronoun( tebia, singular, masculine, genitive, [human(ty)] ).
pronoun( tebia, singular, feminine, genitive, [human(ty)] ).
pronoun( tebe, singular, masculine, dative, [human(ty)] ).
pronoun( tebe, singular, feminine, dative, [human(ty)] ).
pronoun( tebia, singular, masculine, accusative, [human(ty)] ).
pronoun( tebia, singular, feminine, accusative, [human(ty)] ).
pronoun( toboi, singular, masculine, instrumental, [human(ty)] ).
pronoun( toboi, singular, feminine, instrumental, [human(ty)] ).
pronoun( tebe, singular, masculine, prepositional, [human(ty)] ).
pronoun( tebe, singular, feminine, prepositional, [human(ty)] ).

% he/she/it
pronoun( on, singular, masculine, third, nominative, [unknown(on)]).
pronoun( ona, singular, feminine, third, nominative, [unknown(ona)]).
pronoun( ono, singular, neuter, third, nominative, [inanimate(ono)]).
pronoun( ego, singular, masculine, genitive, [unknown(on)] ).
pronoun( ee, singular, feminine, genitive, [unknown(ona)] ).
pronoun( ego, singular, neuter, third, nominative, [inanimate(ono)]).
pronoun( emu, singular, masculine, dative, [unknown(on)] ).
pronoun( ei, singular, feminine, dative, [unknown(ona)] ).
pronoun( emu, singular, neuter, third, nominative, [inanimate(ono)]).
pronoun( ego, singular, masculine, accusative, [unknown(on)] ).
pronoun( ee, singular, feminine, accusative, [unknown(ona)] ).
pronoun( ego, singular, neuter, third, nominative, [inanimate(ono)]).
pronoun( im, singular, masculine, instrumental, [unknown(on)] ).
pronoun( ei, singular, feminine, instrumental, [unknown(ona)] ).
pronoun( im, singular, neuter, third, nominative, [inanimate(ono)]).
pronoun( nem, singular, masculine, prepositional, [unknown(on)] ).
pronoun( nei, singular, feminine, prepositional, [unknown(ona)] ).
pronoun( nem, singular, neuter, third, nominative, [inanimate(ono)]).

% we
pronoun( my, plural, masculine, first, nominative, [human(my)] ).
pronoun( my, plural, feminine, first, nominative, [human(my)] ).
pronoun( nas, plural, masculine, genitive, [human(my)] ).
pronoun( nas, plural, feminine, genitive, [human(my)] ).
pronoun( nam, plural, masculine, dative, [human(my)] ).
pronoun( nam, plural, feminine, dative, [human(my)] ).
pronoun( nas, plural, masculine, accusative, [human(my)] ).
pronoun( nas, plural, feminine, accusative, [human(my)] ).
pronoun( nami, plural, masculine, instrumental, [human(my)] ).
pronoun( nami, plural, feminine, instrumental, [human(my)] ).
pronoun( nas, plural, masculine, prepositional, [human(my)] ).
pronoun( nas, plural, feminine, prepositional, [human(my)] ).

% you all (also used to address someone with respect)
pronoun( vy, plural, masculine, second, nominative, [human(vy)] ).
pronoun( vy, plural, feminine, second, nominative, [human(vy)] ).
pronoun( vas, plural, masculine, genitive, [human(vy)] ).
pronoun( vas, plural, feminine, genitive, [human(vy)] ).
pronoun( vam, plural, masculine, dative, [human(vy)] ).
pronoun( vam, plural, feminine, dative, [human(vy)] ).
pronoun( vas, plural, masculine, accusative, [human(vy)] ).
pronoun( vas, plural, feminine, accusative, [human(vy)] ).
pronoun( vami, plural, masculine, instrumental, [human(vy)] ).
pronoun( vami, plural, feminine, instrumental, [human(vy)] ).
pronoun( vas, plural, masculine, prepositional, [human(vy)] ).
pronoun( vas, plural, feminine, prepositional, [human(vy)] ).

% they
pronoun( oni, plural, masculine, third, nominative, [unknown(oni)]).
pronoun( oni, plural, feminine, third, nominative, [unknown(oni)]).
pronoun( oni, plural, neuter, third, nominative, [inanimate(oni)]).
pronoun( ikh, plural, masculine, genitive, [unknown(oni)] ).
pronoun( ikh, plural, feminine, genitive, [unknown(oni)] ).
pronoun( ikh, plural, neuter, third, nominative, [inanimate(oni)]).
pronoun( im, plural, masculine, dative, [unknown(oni)] ).
pronoun( im, plural, feminine, dative, [unknown(oni)] ).
pronoun( im, plural, neuter, third, nominative, [inanimate(oni)]).
pronoun( ikh, plural, masculine, accusative, [unknown(oni)] ).
pronoun( ikh, plural, feminine, accusative, [unknown(oni)] ).
pronoun( ikh, plural, neuter, third, nominative, [inanimate(oni)]).
pronoun( imi, plural, masculine, instrumental, [unknown(oni)] ).
pronoun( imi, plural, feminine, instrumental, [unknown(oni)] ).
pronoun( imi, plural, neuter, third, nominative, [inanimate(oni)]).
pronoun( nikh, plural, masculine, prepositional, [unknown(oni)] ).
pronoun( nikh, plural, feminine, prepositional, [unknown(oni)] ).
pronoun( nikh, plural, neuter, third, nominative, [inanimate(oni)]).

% the section for verbs, which are syntactically different depending on
% a person and a number (there are different conjugation forms, but 
% I am not going there)

% to play
verb( igrayu, singular, first, [action([igrat(ia)]), agent([human(ia)]), object([game(Y)])] ).
verb( igraem, plural, first, [action([igrat(my)]), agent([human(my)]), object([game(Y)])] ).
verb( igraesh, singular, second, [action([igrat(ty)]), agent([human(ty)]), object([game(Y)])] ).
verb( igraete, plural, second, [action([igrat(vy)]), agent([human(vy)]), object([game(Y)])] ).
verb( igraet, singular, third, [action([igrat(X)]), agent([human(X)]), object([game(Y)])] ).
verb( igrayut, plural, third, [action([igrat(X)]), agent([human(X)]), object([game(Y)])] ).

% to see
verb( vizhu, singular, first, [action([videt(ia)]), agent([human(ia)]), object([unknown(Y)])] ).
verb( videm, plural, first, [action([videt(my)]), agent([human(my)]), object([unknown(Y)])] ).
verb( videsh, singular, second, [action([videt(ty)]), agent([human(ty)]), object([unknown(Y)])] ).
verb( videte, plural, second, [action([videt(vy)]), agent([human(vy)]), object([unknown(Y)])] ).
verb( videt, singular, third, [action([videt(X)]), agent([human(X)]), object([unknown(Y)])] ).
verb( vidiat, plural, third, [action([videt(X)]), agent([human(X)]), object([unknown(Y)])] ).

% to eat
verb( em, singular, first, [action([est(ia)]), agent([human(ia)]), object([food(Y)])] ).
verb( edim, plural, first, [action([est(my)]), agent([human(my)]), object([food(Y)])] ).
verb( esh, singular, second, [action([est(ty)]), agent([human(ty)]), object([food(Y)])] ).
verb( edite, plural, second, [action([est(vy)]), agent([human(vy)]), object([food(Y)])] ).
verb( est, singular, third, [action([est(X)]), agent([animate(X)]), object([food(Y)])] ).
verb( ediat, plural, third, [action([est(X)]), agent([animate(X)]), object([food(Y)])] ).

% to think
verb( dumaiu, singular, first, [action([dumat(ia)]), agent([human(ia)]), object([unknown(Y)])] ).
verb( dumaem, plural, first, [action([dumat(my)]), agent([human(my)]), object([unknown(Y)])] ).
verb( dumaesh, singular, second, [action([dumat(ty)]), agent([human(ty)]), object([unknown(Y)])] ).
verb( dumaete, plural, second, [action([dumat(vy)]), agent([human(vy)]), object([unknown(Y)])] ).
verb( dumaet, singular, third, [action([dumat(X)]), agent([human(X)]), object([unknown(Y)])] ).
verb( dumaiut, plural, third, [action([dumat(X)]), agent([human(X)]), object([unknown(Y)])] ).

% to meet
verb( vstrechu, singular, first, [action([vstretit(ia)]), agent([human(ia)]), object([unknown(Y)])] ).
verb( vstretim, plural, first, [action([vstretit(my)]), agent([human(my)]), object([unknown(Y)])] ).
verb( vstretish, singular, second, [action([vstretit(ty)]), agent([human(ty)]), object([unknown(Y)])] ).
verb( vstretite, plural, second, [action([vstretit(vy)]), agent([human(vy)]), object([unknown(Y)])] ).
verb( vstretit, singular, third, [action([vstretit(X)]), agent([unknown(X)]), object([unknown(Y)])] ).
verb( vstretiat, plural, third, [action([vstretit(X)]), agent([unknown(X)]), object([unknown(Y)])] ).

% the section for adjective, which are syntactically different depending on a gender,
% a number and a case

% tasty
adjective( vkusnyi, singular, masculine, nominative ).
adjective( vkusnaia, singular, feminine, nominative ).
adjective( vkusnoe, singular, neuter, nominative ).
adjective( vkusnye, plural, masculine, nominative ).
adjective( vkusnye, plural, feminine, nominative ).
adjective( vkusnye, plural, neuter, nominative ).
adjective( vkusnogo, singular, masculine, genitive ).
adjective( vkusnoy, singular, feminine, genitive ).
adjective( vkusnogo, singular, neuter, genitive ).
adjective( vkusnykh, plural, masculine, genitive ).
adjective( vkusnykh, plural, feminine, genitive ).
adjective( vkusnykh, plural, neuter, genitive ).
adjective( vkusnomu, singular, masculine, dative ).
adjective( vkusnoy, singular, feminine, dative ).
adjective( vkusnomu, singular, neuter, dative ).
adjective( vkusnym, plural, masculine, dative ).
adjective( vkusnym, plural, feminine, dative ).
adjective( vkusnym, plural, neuter, dative ).
adjective( vkusnyi, singular, masculine, accusative ).
adjective( vkusnuiu, singular, feminine, accusative ).
adjective( vkusnoe, singular, neuter, accusative ).
adjective( vkusnye, plural, masculine, accusative ).
adjective( vkusnye, plural, feminine, accusative ).
adjective( vkusnye, plural, neuter, accusative ).
adjective( vkusnym, singular, masculine, instrumental ).
adjective( vkusnoy, singular, feminine, instrumental ).
adjective( vkusnym, singular, neuter, instrumental ).
adjective( vkusnymi, plural, masculine, instrumental ).
adjective( vkusnymi, plural, feminine, instrumental ).
adjective( vkusnymi, plural, neuter, instrumental ).
adjective( vkusnom, singular, masculine, prepositional ).
adjective( vkusnoi, singular, feminine, prepositional ).
adjective( vkusnom, singular, neuter, prepositional ).
adjective( vkusnykh, plural, masculine, prepositional ).
adjective( vkusnykh, plural, feminine, prepositional ).
adjective( vkusnykh, plural, neuter, prepositional ).

% beautiful
adjective( krasivyi, singular, masculine, nominative ).
adjective( krasivaia, singular, feminine, nominative ).
adjective( krasivoe, singular, neuter, nominative ).
adjective( krasivye, plural, masculine, nominative ).
adjective( krasivye, plural, feminine, nominative ).
adjective( krasivye, plural, neuter, nominative ).
adjective( krasivogo, singular, masculine, genitive ).
adjective( krasivoi, singular, feminine, genitive ).
adjective( krasivogo, singular, neuter, genitive ).
adjective( krasivikh, plural, masculine, genitive ).
adjective( krasivikh, plural, feminine, genitive ).
adjective( krasivikh, plural, neuter, genitive ).
adjective( krasivomu, singular, masculine, dative ).
adjective( krasivoi, singular, feminine, dative ).
adjective( krasivomu, singular, neuter, dative ).
adjective( krasivym, plural, masculine, dative ).
adjective( krasivym, plural, feminine, dative ).
adjective( krasivym, plural, neuter, dative ).
adjective( krasivogo, singular, masculine, accusative ).
adjective( krasivuiu, singular, feminine, accusative ).
adjective( krasivoe, singular, neuter, accusative ).
adjective( krasivikh, plural, masculine, accusative ).
adjective( krasivikh, plural, feminine, accusative ).
adjective( krasivikh, plural, neuter, accusative ).
adjective( krasivym, singular, masculine, instrumental ).
adjective( krasivoi, singular, feminine, instrumental ).
adjective( krasivym, singular, neuter, instrumental ).
adjective( krasivymi, plural, masculine, instrumental ).
adjective( krasivymi, plural, feminine, instrumental ).
adjective( krasivymi, plural, neuter, instrumental ).
adjective( krasivom, singular, masculine, prepositional ).
adjective( krasivoi, singular, feminine, prepositional ).
adjective( krasivom, singular, neuter, prepositional ).
adjective( krasivikh, plural, masculine, prepositional ).
adjective( krasivikh, plural, feminine, prepositional ).
adjective( krasivikh, plural, neuter, prepositional ).

% noisy
adjective( shumnyi, singular, masculine, nominative ).
adjective( shumnaia, singular, feminine, nominative ).
adjective( shumnoe, singular, neuter, nominative ).
adjective( shumnye, plural, masculine, nominative ).
adjective( shumnye, plural, feminine, nominative ).
adjective( shumnye, plural, neuter, nominative ).
adjective( shumnogo, singular, masculine, genitive ).
adjective( shumnoy, singular, feminine, genitive ).
adjective( shumnogo, singular, neuter, genitive ).
adjective( shumnykh, plural, masculine, genitive ).
adjective( shumnykh, plural, feminine, genitive ).
adjective( shumnykh, plural, neuter, genitive ).
adjective( shumnomu, singular, masculine, dative ).
adjective( shumnoy, singular, feminine, dative ).
adjective( shumnomu, singular, neuter, dative ).
adjective( shumnym, plural, masculine, dative ).
adjective( shumnym, plural, feminine, dative ).
adjective( shumnym, plural, neuter, dative ).
adjective( shumnogo, singular, masculine, accusative ).
adjective( shumnuiu, singular, feminine, accusative ).
adjective( shumnoe, singular, neuter, accusative ).
adjective( shumnykh, plural, masculine, accusative ).
adjective( shumnykh, plural, feminine, accusative ).
adjective( shumnykh, plural, neuter, accusative ).
adjective( shumnym, singular, masculine, instrumental ).
adjective( shumnoi, singular, feminine, instrumental ).
adjective( shumnym, singular, neuter, instrumental ).
adjective( shumnymi, plural, masculine, instrumental ).
adjective( shumnymi, plural, feminine, instrumental ).
adjective( shumnymi, plural, neuter, instrumental ).
adjective( shumnom, singular, masculine, prepositional ).
adjective( shumnoi, singular, feminine, prepositional ).
adjective( shumnom, singular, neuter, prepositional ).
adjective( shumnykh, plural, masculine, prepositional ).
adjective( shumnykh, plural, feminine, prepositional ).
adjective( shumnykh, plural, neuter, prepositional ).

% smart
adjective( umnyi, singular, masculine, nominative ).
adjective( umnaia, singular, feminine, nominative ).
adjective( umnoe, singular, neuter, nominative ).
adjective( umnye, plural, masculine, nominative ).
adjective( umnye, plural, feminine, nominative ).
adjective( umnye, plural, neuter, nominative ).
adjective( umnogo, singular, masculine, genitive ).
adjective( umnuiu, singular, feminine, genitive ).
adjective( umnogo, singular, neuter, genitive ).
adjective( umnykh, plural, masculine, genitive ).
adjective( umnykh, plural, feminine, genitive ).
adjective( umnykh, plural, neuter, genitive ).
adjective( umnomu, singular, masculine, dative ).
adjective( umnoy, singular, feminine, dative ).
adjective( umnomu, singular, neuter, dative ).
adjective( umnym, plural, masculine, dative ).
adjective( umnym, plural, feminine, dative ).
adjective( umnym, plural, neuter, dative ).
adjective( umnogo, singular, masculine, accusative ).
adjective( umnuiu, singular, feminine, accusative ).
adjective( umnoe, singular, neuter, accusative ).
adjective( umnykh, plural, masculine, accusative ).
adjective( umnykh, plural, feminine, accusative ).
adjective( umnykh, plural, neuter, accusative ).
adjective( umnym, singular, masculine, instrumental ).
adjective( umnoi, singular, feminine, instrumental ).
adjective( umnym, singular, neuter, instrumental ).
adjective( umnymi, plural, masculine, instrumental ).
adjective( umnymi, plural, feminine, instrumental ).
adjective( umnymi, plural, neuter, instrumental ).
adjective( umnom, singular, masculine, prepositional ).
adjective( umnoy, singular, feminine, prepositional ).
adjective( umnom, singular, neuter, prepositional ).
adjective( umnykh, plural, masculine, prepositional ).
adjective( umnykh, plural, feminine, prepositional ).
adjective( umnykh, plural, neuter, prepositional ).

% green
adjective( zelenyi, singular, masculine, nominative ).
adjective( zelenaia, singular, feminine, nominative ).
adjective( zelenoe, singular, neuter, nominative ).
adjective( zelenye, plural, masculine, nominative ).
adjective( zelenye, plural, feminine, nominative ).
adjective( zelenye, plural, neuter, nominative ).
adjective( zelenogo, singular, masculine, genitive ).
adjective( zelenoy, singular, feminine, genitive ).
adjective( zelenogo, singular, neuter, genitive ).
adjective( zelenykh, plural, masculine, genitive ).
adjective( zelenykh, plural, feminine, genitive ).
adjective( zelenykh, plural, neuter, genitive ).
adjective( zelenomu, singular, masculine, dative ).
adjective( zelenoy, singular, feminine, dative ).
adjective( zelenomu, singular, neuter, dative ).
adjective( zelenym, plural, masculine, dative ).
adjective( zelenym, plural, feminine, dative ).
adjective( zelenym, plural, neuter, dative ).
adjective( zelenogo, singular, masculine, accusative ).
adjective( zelenuiu, singular, feminine, accusative ).
adjective( zelenoe, singular, neuter, accusative ).
adjective( zelenykh, plural, masculine, accusative ).
adjective( zelenykh, plural, feminine, accusative ).
adjective( zelenykh, plural, neuter, accusative ).
adjective( zelenym, singular, masculine, instrumental ).
adjective( zelenoi, singular, feminine, instrumental ).
adjective( zelenym, singular, neuter, instrumental ).
adjective( zelenymi, plural, masculine, instrumental ).
adjective( zelenymi, plural, feminine, instrumental ).
adjective( zelenymi, plural, neuter, instrumental ).
adjective( zelenom, singular, masculine, prepositional ).
adjective( zelenoi, singular, feminine, prepositional ).
adjective( zelenom, singular, neuter, prepositional ).
adjective( zelenykh, plural, masculine, prepositional ).
adjective( zelenykh, plural, feminine, prepositional ).
adjective( zelenykh, plural, neuter, prepositional ).

% the section for prepositions that identify the case
% of the words after it (there are exceptions..., but 
% not now)

% from
preposition( ot, genitive ).
% from
preposition( iz, genitive ).
% without
preposition( bez, genitive ).
% for
preposition( dlia, genitive ).
% after
preposition( posle, genitive ).
% to
preposition( k, dative ).
% on
preposition( po, dative ).
% in 
preposition( v, accusative ).
% on
preposition( na, accusative ).
% under
preposition( pod, instrumental ).
% in front
preposition( pered, instrumental ).
% behind
preposition( za, instrumental ).
% above
preposition( nad, instrumental ).
% near by; it should be "riadom s"
preposition( riadoms, instrumental ).
% about
preposition( o, prepositional ).
% in; same as in accusative case, however I don't know a syntactic 
% way to distinguish these cases
preposition( v, prepositional ).
% on; same as in accusative case, however I don't know a syntactic 
% way to distinguish these cases
preposition( na, prepositional ).
