:-module(set,
	[
	 %% predicates
	 empty_set/1, insert_set/3, delete_set/3, member_set/2, union_set/3,
	 %% regtypes
	 set/1
	],
	[assertions,isomodes,regtypes]).

:- use_module(library(sets)). 


:- comment(title, "Set").
:- comment(author,"Jorge Navas").
:- comment(module,"This module provides a set of predicates for
	           @index{set}s processing. It uses the library @lib{sets}
	           defined in the @concept{Ciao-Prolog System}.").

%% Predicates

:- pred empty_set(?S):: set
#" @var{S} is empty. 

   @item @em{Code:}
   @includedef{empty_set/1}
".
	

empty_set([]).

:- pred insert_set(-Set1, -Element, +Set2):: set * term * set
# "It is true when @var{Set2} is @var{Set1} with @var{Element} 
   inserted in it, preserving the order.

   @item @em{Code:}
   @includedef{insert_set/3}".

insert_set(S1,E,S2):- insert(S1,E,S2).

:- pred member_set(?E,-S):: term * set
#"Checks the element @var{E} belongs to @var{S}.

   @item @em{Code:}
   @includedef{member_set/2}". 

member_set(E,S):- member(E,S).

:- pred delete_set(-Set0,-X,+Set):: set * term * set
# "It succeeds if @var{Set} is @var{Set0} without element @var{X}.

   @item @em{Code:}
   @includedef{delete_set/3}".

delete_set(S0,X,S) :- ord_delete(S0,X,S).

:- pred union_set(+Set1, +Set2, ?Union) 
# "It is true when @var{Union} is the union of @var{Set1} and @var{Set2}.
   When some element occurs in both sets, @var{Union} retains only one
   copy.

   @item @em{Code:}
   @includedef{union_set/3}".

union_set(S1,S2,U):- ord_union(S1,S2,U).


%% Regtypes

:- regtype set(S) #"@var{S} is a @concept{set}.".

set(S):- list(S).
