:- module(flat_stopper,[rule/2,askable/1]).


% %%%
% Knowledge Base for avoiding bike flats, they are really nasty here in NM
% Usage : 
% ?- solve(advice(X),CF). 
% starts asking for determining the cause of the flats and give and advice
%
% %%%

rule((advice(Advice) :-
	(bad_component(X),fix(X, Advice))), 100).
rule((advice(Advice) :-
	(weak(X),change(X,Advice))),100).
rule((advice('You are a lucky guy, so go and ride without fear!') :-
	(not(flats(every_day)), not(flats(often)))),100).
rule((advice('No reasonable cause found...do you live close to Roswell?')),100).

% rules to inspect whether the flats are caused by defective components
rule((bad_component(rim_strip):-
	(flats(every_day),localized(same_area),shape_is_regular)),90).
rule((bad_component(tire):-
	(flats(every_day),localized(same_area),not(shape_is_regular))),70).
rule((bad_component(patch):-
	(flats(every_day),localized(previous_patch))),95).


% rules about weak components, it's better to buy more resistant ones
rule((weak(tire_tube):-
	(flats(often),living_southwest),reason(important)),90).
rule((weak(tire):-
	(flats(often),(living_southwest or reason(medium)))),70).
rule((weak(tire):-
	(flats(often),not(living_southwest), reason(important))),70).
rule((weak(tube):-
	(flats(often),not(living_southwest),(reason(weak) or reason(medium)))),70).
rule((reason(important) :-
	(cause(nail) or cause(thorn))),100).
rule((reason(medium) :-
	(cause(glass) or cause(debris))),80).
rule((reason(weak) :-
	(not(cause(nail)),not(cause(glass),not(cause(thorn))))),80).


rule(X,100):-sure(X).

% Advices about bad components	
sure(fix(rim_strip, 'Replace the rim strip or place it properly')).
sure(fix(patch, 'You are not patching correctly or the patch does not stick')).
sure(fix(tire, 'The tire still has something stuck on it that is causing the
 new flats')).

% Advices about change the tube, tire or both
sure(change(tire_tube,'Maybe it is better to buy an Armadillo tire AND 
thorn-resistant tubes')).
sure(change(tire,'Buy thicker tires (Specialized Armadillo,Vredestein Spider) 
or use tire liners')).
sure(change(tube,'Using Slimer or switching to self-sealant tubes should be
 enough')).

% Askable descriptions
askable(flats(_)).
askable(localized(_)).
askable(shape_is_regular).

askable(living_southwest).
askable(cause(_)).
